/****** Object:  Trigger [TRG_PG_DEB_POSICAO_FINANCEIRA_PROC]    Script Date: 20/07/2016 13:57:54 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_PG_DEB_POSICAO_FINANCEIRA_PROC]'))
 DROP TRIGGER [dbo].[TRG_PG_DEB_POSICAO_FINANCEIRA_PROC]
 go
CREATE TRIGGER [dbo].[TRG_PG_DEB_POSICAO_FINANCEIRA_PROC] ON [dbo].[PG_DEB] FOR INSERT,UPDATE AS
--Controle de posicao financeira
UPDATE
	p
SET 
	p.DT_PROC=i.DT_PAG,
	p.DT_CAD=GETDATE()
FROM
	PG_CRED_POSICAO_FINANCEIRA_PROCESSAR p 
	INNER JOIN INSERTED i ON
	p.CD_EMP = i.CD_EMP AND
	p.CD_FILIAL = i.CD_FILIAL
WHERE
	p.DT_PROC > i.DT_PAG;

--Caso nao tenha cadastre
INSERT INTO PG_CRED_POSICAO_FINANCEIRA_PROCESSAR
	(CD_EMP,
	CD_FILIAL,
	DT_PROC,
	DT_CAD)
SELECT DISTINCT 
	i.CD_EMP,
	i.CD_FILIAL,
	MIN(i.DT_PAG),
	GETDATE()
FROM
	INSERTED i 
	LEFT OUTER JOIN PG_CRED_POSICAO_FINANCEIRA_PROCESSAR p ON
	p.CD_EMP = i.CD_EMP AND
	p.CD_FILIAL = i.CD_FILIAL 
WHERE
	 p.CD_FILIAL IS NULL
GROUP BY
	i.CD_EMP,
	i.CD_FILIAL


